/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.validator.rule;

import ec.gob.sri.dimm.ats.modelo.obj.ventas.ComprobanteVenta;
import java.util.Arrays;
import java.util.List;

public class VentasValidationRule {
    private static final String CODIGO_NOTA_DE_CREDITO_04 = "04";
    private static final String CODIGO_COMPENSACION_SOLIDARIDAD_01 = "01";
    private static final String TIPO_DE_EMISION_DE_COMPROBANTE_ELECTRONICA = "E";
    private static final List<String> CODIGOS_NOTAS_DE_CREDITO_VENTAS = Arrays.asList("04", "47", "51");

    public static final boolean esCompensacionPorLeyDeSolidaridad(String codigoCompensacion) {
        return CODIGO_COMPENSACION_SOLIDARIDAD_01.equals(codigoCompensacion);
    }

    public static final boolean esComprobanteElectronico(ComprobanteVenta comprobanteVenta) {
        return TIPO_DE_EMISION_DE_COMPROBANTE_ELECTRONICA.equals(comprobanteVenta.getTipoEmision());
    }

    public static final boolean esNotaDeCredito(ComprobanteVenta comprobanteVenta) {
        return CODIGO_NOTA_DE_CREDITO_04.equals(comprobanteVenta.getTipoComprobante());
    }

    public static final boolean esNotaDeCreditoEnVentas(ComprobanteVenta comprobanteVenta) {
        return CODIGOS_NOTAS_DE_CREDITO_VENTAS.contains(comprobanteVenta.getTipoComprobante());
    }
}

